function [] = PLV_Ana(SimplyName,FullName)
%UNTITLED13 此处提供此函数的摘要
%   此处提供详细说明
workpath='E:\DATA_SEEG';
cd(workpath)
load('DOTAnatomy1.mat');
Atlas_DKT={};
Atlas_DKT{1}={'superiorfrontal','rostralmiddlefrontal','caudalmiddlefrontal',...
    'parsopercularis','parsorbitalis','parstriangularis','lateralorbitofrontal'...
    ,'medialorbitofrontal','precentral','paracentral','frontalpole'...
    ,'caudalanteriorcingulate','rostralanteriorcingulate'};  %
Atlas_DKT{2}={'superiorparietal','inferiorparietal','supramarginal','postcentral'...
    ,'precuneus','posteriorcingulate','isthmuscingulate'};
Atlas_DKT{3}={'superiortemporal','middletemporal','inferiortemporal','bankssts',...
    'fusiform','transversetemporal','entorhinal','temporalpole','parahippocampal','insula'};
Atlas_DKT{4}={'lateraloccipital','lingual','cuneus','pericalcarine'};
Atlas_DKT{5}={'Thalamus','Caudate','Amygdala','Hippocampus','Putaman','Pallidum'};

DKT_Lobe=[];
for i_lobe=1:length(Atlas_DKT)
    for i=1:length(Atlas_DKT{i_lobe})
        DKT_Lobe{i_lobe}{1,i}=[Atlas_DKT{i_lobe}{i},' L'];
        DKT_Lobe{i_lobe}{2,i}=[Atlas_DKT{i_lobe}{i},' R'];
    end
end

for i_sub=1:length(DOTAnatomy1)
    DOTAnatomy1{1,i_sub}.Properties.VariableNames(7)={'white_DKT'};
end

FigSort=DOTAnatomy1;
LobeName={'N/A','Frontal','Parietal','Temporal','Occipital','Subcortical'};
for i_sub=1:length(DOTAnatomy1)
    for i_lobe=1:length(DKT_Lobe)
        roi=DKT_Lobe{1,i_lobe};
        siteAdr=ismember(DOTAnatomy1{1,i_sub}.white_DKT,roi); %位于ROI内
     
        if i_lobe==5            %皮层下结构
                siteAdr=ismember(DOTAnatomy1{1,i_sub}.ASEG,roi) & ...
                    FigSort{1,i_sub}.white_Lobe==0;   %以皮层分区为主，皮层无分区的再判定皮层下结构；
        end
           FigSort{1,i_sub}.white_Lobe(siteAdr)=i_lobe;
    end
end

%% 按解剖将位点排序
% 
% Figtemp1=plv_wrh;  %这里的数组需从BST导出
% i_sub=2;
% % for i_sub=1:length(DOTAnatomy1)
%     temp1=FigSort{1,i_sub};
% 
% [temp,~]=sortrows(temp1,[10 7 9],{'descend','ascend','ascend'}); %按照解剖学排序
% [temp_adr,order1]=ismember(temp.Channel,Figtemp1.RowNames);
% temp(order1==0,:)=[];
% order1(order1==0,:)=[];       %通过order1能将原始A1-A2等顺序按照FigSort数据中解剖学位置排序；
% % a=Figtemp1.RowNames(order1);  %这里可以验证/检查;
% % DOTAnatomy1{4,i_sub}=order1;
% % end
% 
% [a,a1,a2]=unique(temp.white_Lobe,'stable');
% 
% a4=find(diff(a2)~=0);
% xline(a4+1,'LineWidth',1)
% yline(a4+1,'LineWidth',1)
% a3=movsum([0;a4;length(a2)],2)/2;
% % yline(a1,'k--','LineWidth',2)
% xticks(a3(2:end));
% xticklabels(LobeName(a+1));
% yticks(a3(2:end));
% yticklabels(LobeName(a+1));
% set(gca,'ydir','normal')
% %% 将BST中导出的数据重新排序（数组解压缩、排序、压缩）
% 
% Figtemp2 = bst_memory('GetConnectMatrix',Figtemp1);
% Figtemp2=Figtemp2(order1,order1,:,:);
% size(Figtemp2)
% TF_back=[];
% for i_comp=1:size(Figtemp2,4)
%     for i_time=1:size(Figtemp2,3)
%     temp_comp=Figtemp2(:,:,i_time,i_comp);
%     TF_back(:,i_time,i_comp) = process_compress_sym('Compress',temp_comp(:));
%     end
% end
% Figtemp_back=Figtemp1;
% Figtemp_back.TF=TF_back;
% Figtemp_back.RefRowNames=Figtemp_back.RefRowNames(order1);
% Figtemp_back.RowNames=Figtemp_back.RowNames(order1);
% Figtemp_back.Comment=[Figtemp_back.Comment,'_sorted'];
% % 将Figtemp_back导入BST中即可

%% 截图
TimeOfInterest=[0 0.6];
FigStep=0.15;

subName=[];
for i_name=1:size(FigSort,2)
    subName{1,i_name}=FigSort{3,i_name};
end


name={SimplyName};
 name2={FullName};
condition={'NA','NU'};
for i_sub=1:length(name)

    workpath=['E:\DATA_SEEG\',name2{i_sub},'_data'];
    cd(workpath)
    mkdir('PLV');
    cd('PLV')
    outputpath=[workpath,'\PLV'];

 


    base_plv=[];
    dataTemp=[];
    data_plv_sorted=[];
     for i_condi=1:2
         workpath=['E:\Software\brainstorm_db\Protocol01\data\',name{i_sub},'\',condition{i_condi},'_bipolar_2'];
         cd(workpath)
         FileList=dir('*plvt*');
         data_plv=load(FileList(end).name);

         Time=data_plv.Time;
         data_plv1 = bst_memory('GetConnectMatrix',data_plv);

subseq=find(ismember(subName,name{i_sub}));

    temp1=FigSort{1,subseq};

         [temp,~]=sortrows(temp1,[10 7 9],{'descend','ascend','ascend'}); %按照解剖学排序
         [temp_adr,order1]=ismember(temp.Channel,data_plv.RowNames);
         temp(order1==0,:)=[];
         order1(order1==0,:)=[];       %通过order1能将原始A1-A2等顺序按照FigSort数据中解剖学位置排序；
    
data_plv1=data_plv1(order1,order1,:,:);
data_plv_sorted(:,:,:,i_condi)=data_plv1(:,:,:,1);  % 位点X位点X时间X条件（左）/频段（右）
base_plv(:,:,i_condi)=mean(data_plv1(:,:,Time<0 & Time>=-0.20,1),3);

         for i_time=1:round(diff(TimeOfInterest)/FigStep)+1
             timeP=TimeOfInterest(1)+(i_time-1)*FigStep;

             Timetemp=find(Time>=timeP);
             Data_temp=data_plv1(:,:, Timetemp(1),1);
%               Data_temp(eye(size(Data_temp))==1)=0;
             dataTemp(:,:,i_time,i_condi)=Data_temp;
            

         end
     end
     base_plv2condi=mean(base_plv,3);
     dataTemp=dataTemp-base_plv2condi;
         [a,a1,a2]=unique(temp.white_Lobe,'stable');

         a4=find(diff(a2)~=0);

         a3=movsum([0;a4;length(a2)],2)/2;
         % yline(a1,'k--','LineWidth',2)

         figure
         tiledlayout(2,round(diff(TimeOfInterest)/FigStep)+1);
         
         for i_condi=1:2
             for i_time=1:round(diff(TimeOfInterest)/FigStep)+1

                 nexttile
                 timeP=TimeOfInterest(1)+(i_time-1)*FigStep;
                 Timetemp=find(Time>=timeP);

                 
    
% 
%                  if i_condi==1
%                      clim=[min(dataTemp,[],'all'),max(dataTemp,[],'all')];
% %                      clim=prctile(dataTemp,[0.05,99.95],"all")';
%                  end
                 clim=[prctile(dataTemp,5,"all") max(dataTemp,[],'all')];
            
                 imagesc(dataTemp(:,:,i_time,i_condi),clim);
                 colormap jet
                 title([num2str(timeP.*1000),' ms'])

                 xline(a4+1,'LineWidth',1)
                 yline(a4+1,'LineWidth',1)
                 xticks(a3(2:end));
                 xticklabels(LobeName(a+1));
                 yticks(a3(2:end));
                 yticklabels(LobeName(a+1));
                 set(gca,'ydir','normal')

             end
         end
         cb = colorbar;

         cb.Layout.Tile = 'east';
         cb.Label.String = 'Phase-Locking Value';
         sgtitle(name{i_sub})
         set(gcf,'Position',[25 175.6667 1638 614.6667],'Units','pixels')
          cd(outputpath)
         saveas(gcf,['PLV_Dynamics_baseRemv_',name{i_sub}],'tif')
         close

%% 按脑区输出矩阵
a=temp(:,[1,7,9,10]);
adr_modify=ismember(a.white_DKT,{'N/A'});
a.white_DKT(adr_modify)=a.ASEG(adr_modify);

 [a1,a2,a3]=unique(a.white_DKT,'stable');
 a2(:,2)=[a2(2:end)-1;length(a3)];

data_plv2=data_plv_sorted-base_plv2condi;
 Parcel=a1;
 RecordingNum=a2(:,2)-a2(:,1)+1;
 PLVtable=table(Parcel,RecordingNum);

 a_parcel1=[];
 for i_parcel=1:size(a2,1)
 a_parcel1(i_parcel,:,:,:)=mean(data_plv2(a2(i_parcel,1):a2(i_parcel,2),:,:,:),1);
 end
 a_parcel2=[];
  for i_parcel=1:size(a2,1)
 a_parcel2(:,i_parcel,:,:)=mean(a_parcel1(:,a2(i_parcel,1):a2(i_parcel,2),:,:),2);
 end


 timeseq=300;
 clim=[prctile(a_parcel2,1,"all") prctile(a_parcel2,99,'all')];
 for i_condi=1:2
 for i_time=1:length(timeseq)
 figure
 imagesc(a_parcel2(:,:,timeseq(i_time)+490,i_condi),clim)
 xticks(1:length(a1))
 xticklabels(a1)
  yticks(1:length(a1))
 yticklabels(a1)
 colorbar
sgtitle([num2str(timeseq(i_time)),' ms'])
  set(gca,'ydir','normal')
 end
 saveas(gcf,['PLV_Dynamics_baseRemv_',condition{i_condi},'_',name{i_sub},'_parcel'],'tif')
 close
 end
 plv_sorted_parcel=a_parcel2;
 parcels=a1;
 save  plv_sorted_parcel plv_sorted_parcel parcels PLVtable

end
end